package jamezo97.clonecraft.network;

import jamezo97.clonecraft.block.TileEntityLifeInducer;
import jamezo97.clonecraft.entity.EntitySparkFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.CloneCraftWorld;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class Handler3LifeInducerUpdates extends Handler{
	
	@Value(id = 0)
	int x;
	@Value(id = 1)
	int y;
	@Value(id = 2)
	int z;
	@Value(id = 3)
	int type;
	@Value(id = 4)
	int meta;
	
	public Handler3LifeInducerUpdates(){
		
	}
	
	public Handler3LifeInducerUpdates(int x, int y, int z, int type, int meta){
		this.x = x;
		this.y = y;
		this.z = z;
		this.type = type;
		this.meta = meta;
	}

	@SideOnly(value = Side.CLIENT)
	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		World world = player.worldObj;
		if(type == 0){
			for(double yV = y; yV < y+1; yV+= .02){
				EntityFX e = new EntitySparkFX(world, x+.5, yV, z+.5, 1);
				CloneCraftWorld.spawnParticle(e);
				world.playSound(x+.5, yV, z+.5, "clonecraft.zoom", .5f, 1.0f, false);
			}
		}else if(type == 1){
			for(double yV = y; yV < y+1; yV+= .0025){
				EntityFX e = new EntitySparkFX(world, x+.5, yV, z+.5, 4);
				CloneCraftWorld.spawnParticle(e);
				world.playSound(x+.5, yV, z+.5, "clonecraft.zoom", .5f, .2f, false);
				world.playSound(x+.5, yV, z+.5, "random.explode", .2f, 1.5f, false);
			}
		}
		
	}

}
